#!/usr/bin/env python3

"""
#====================================================================
Module that adds some useful input layouts.
~Graham
#====================================================================
"""

#====================================================================
import re
import tkinter as tk
#====================================================================

"""
#====================================================================
We expect the user to enter colors with hex values from 00-FF, and
here we use a regular expression to parse the value they entered.
#====================================================================
"""
def ParseValue(textEntry):
    value = 0;
    string = textEntry.get()

    if re.search("^[0-9A-Fa-f][0-9A-Fa-f]?$", string):
        value = int(string, 16)
    else:
        textEntry.set('00')

    return value

"""
#====================================================================
Class that adds a set of widgets useful for configuring a
paintbrush, including hue intensity and brush size. Also includes
widgets for configuring fill and sort options.
#====================================================================
"""
class ColorInput(tk.Frame):
    def __init__(self, master):
        self.master = master
        tk.Frame.__init__(self, master)

        self.configWidgets()

    """
    #================================================================
    Initializaiton method
    #================================================================
    """
    def configWidgets(self):
        master = self.master

        #Entres for hue intensities and brush size
        self.textColorRed = tk.StringVar()
        self.textColorRed.set('00')
        self.textColorGreen = tk.StringVar()
        self.textColorGreen.set('00')
        self.textColorBlue = tk.StringVar()
        self.textColorBlue.set('00')
        self.textColorAlpha = tk.StringVar()
        self.textColorAlpha.set('FF')
        self.textBrushSize = tk.StringVar()
        self.textBrushSize.set('16')

        #Using buttons so the user can click to turn hues on and off
        self.labelColorRed = tk.Button(
            self,
            command = lambda: self.ToggleColor(self.textColorRed),
            text = 'Red:')
        self.labelColorGreen = tk.Button(
            self,
            command = lambda: self.ToggleColor(self.textColorGreen),
            text = 'Green:')
        self.labelColorBlue = tk.Button(
            self,
            command = lambda: self.ToggleColor(self.textColorBlue),
            text = 'Blue:')
        self.labelColorAlpha = tk.Button(
            self,
            command = lambda: self.ToggleColor(self.textColorAlpha),
            text = 'Alpha:')

        self.labelBrushSize = tk.Label(self, text = 'Brush Size:')

        self.entryColorRed = tk.Entry(
            self, width = 2, textvariable = self.textColorRed)
        self.entryColorGreen = tk.Entry(
            self, width = 2, textvariable = self.textColorGreen)
        self.entryColorBlue = tk.Entry(
            self, width = 2, textvariable = self.textColorBlue)
        self.entryColorAlpha = tk.Entry(
            self, width = 2, textvariable = self.textColorAlpha)
        self.entryBrushSize = tk.Entry(
            self, width = 2, textvariable = self.textBrushSize)

        #Radiobuttons for sort and fill types        
        self.selectSortType = tk.IntVar()
        self.selectSortHue = tk.Radiobutton(
            self,
            text = "Sort by Hue",
            variable = self.selectSortType,
            value = 1)
        self.selectSortBrightness = tk.Radiobutton(
            self,
            text = "Sort by Brightness",
            variable = self.selectSortType,
            value = 2)
        self.selectSortHue.select()

        self.selectFillType = tk.IntVar()
        self.selectFillHue = tk.Radiobutton(
            self,
            text = "Random fill colors are a single hue",
            variable = self.selectFillType,
            value = 1)
        self.selectFillAny = tk.Radiobutton(
            self,
            text = "Random fill colors are any color",
            variable = self.selectFillType,
            value = 2)
        self.selectFillHue.select()

        #Grid everything
        self.labelColorRed.grid(row = 0, column = 1, sticky = tk.E)
        self.labelColorGreen.grid(row = 1, column = 1, sticky = tk.E)
        self.labelColorBlue.grid(row = 2, column = 1, sticky = tk.E)
        self.labelColorAlpha.grid(row = 3, column = 1, sticky = tk.E)
        self.labelBrushSize.grid(row = 4, column = 1, sticky = tk.E)
        self.entryColorRed.grid(row = 0, column = 2, sticky = tk.W)
        self.entryColorGreen.grid(row = 1, column = 2, sticky = tk.W)
        self.entryColorBlue.grid(row = 2, column = 2, sticky = tk.W)
        self.entryColorAlpha.grid(row = 3, column = 2, sticky = tk.W)
        self.entryBrushSize.grid(row = 4, column = 2, sticky = tk.W)
        self.selectSortHue.grid(row = 0, column = 0, sticky = tk.W)
        self.selectSortBrightness.grid(
            row = 1, column = 0, sticky = tk.W)
        tk.Label(self).grid(row = 2, column = 0, sticky = tk.W)
        self.selectFillHue.grid(row = 3, column = 0, sticky = tk.W)
        self.selectFillAny.grid(row = 4, column = 0, sticky = tk.W)

    """
    #================================================================
    Toggles hues on and off when the user clicks them.
    #================================================================
    """
    def ToggleColor(self, colorText):
        if colorText.get() == 'FF':
            colorText.set('00')
            return
        
        colorText.set('FF')

    """
    #================================================================
    Query the hue intensity entires and returns a color
    #================================================================
    """
    def GetColor(self):
        R = ParseValue(self.textColorRed)
        G = ParseValue(self.textColorGreen)
        B = ParseValue(self.textColorBlue)
        A = ParseValue(self.textColorAlpha)

        return (R, G, B, A)

    """
    #================================================================
    Query the brush size entry and parse it's value
    #================================================================
    """
    def GetSize(self):
        size = self.textBrushSize
        if re.search("^\d+$", size.get()):
            return int(self.textBrushSize.get())
        else:
            size.set("16")
            return 16

    """
    #================================================================
    Get or set the sort type
    #================================================================
    """
    def SortType(self, type = 0):
        if type == 0:
            return self.selectSortType.get()
        
        if type == 1:
            self.selectSortHue.select()

        if type == 2:
            self.selectSortBrightness.select()
        
    """
    #================================================================
    Get or set the fill type
    #================================================================
    """
    def FillType(self, type = 0):
        if type == 0:
            return self.selectFillType.get()

        if type == 1:
            self.selectFillHue.select()

        if type == 2:
            self.selectFillAny.select()
    

"""
#====================================================================
Class that adds a set of widgets for a filename prompt.
#====================================================================
"""
class FileInput(tk.Frame):
    def __init__(self, master):
        self.master = master
        tk.Frame.__init__(self, master)

        self.configWidgets()

    """
    #================================================================
    Initialization method
    #================================================================
    """
    def configWidgets(self):
        master = self.master

        #Label and entry for a filname prompt
        self.textSaveFilename = tk.StringVar()

        self.labelSave = tk.Label(
            self, text = 'Enter save filename: ')
        self.entrySaveFilename = tk.Entry(
            self,
            width = 24,
            textvariable = self.textSaveFilename)

        #Grid everything
        self.labelSave.grid(
            row = 1, column = 0, padx = (10, 0), sticky = tk.W)
        self.entrySaveFilename.grid(
            row = 1, column = 1, sticky = tk.W)

    """
    #================================================================
    Get or set the filename
    #================================================================
    """
    def Filename(self, text = ""):
        if text != "":
            self.textSaveFilename.set(text)
        
        text = self.textSaveFilename.get()

        #Filenames are letters and numbers must end with .png
        if re.search("^[0-9a-z]+.png$", text, re.IGNORECASE):
            return text

        text = "default.png"
        self.textSaveFilename.set(text)
        return text       

"""
#====================================================================
"""

if __name__ == '__main__':
    print('This module is not meant to be run by itself.')
